/*
 * Decompiled with CFR 0.152.
 */
package app;

import java.util.Map;
import java.util.TreeMap;
import util.Logger;

public class PlotDataXY {
    static Logger logger = Logger.getLogger();
    public Map<Double, Double> DataMap;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public PlotDataXY() {
        logger.entry(4, "PlotDataXY.PlotDataXY");
        this.DataMap = new TreeMap<Double, Double>();
        this.minX = 0.0;
        this.maxX = 0.0;
        this.minY = 0.0;
        this.maxY = 0.0;
        logger.exit(4, "PlotDataXY.PlotDataXY");
    }

    public double getY(double x) {
        return this.DataMap.get(x);
    }

    public void addPoint(double x, double y) {
        this.DataMap.put(x, y);
        if (this.DataMap.size() == 0) {
            this.minX = x;
            this.maxX = x;
            this.minY = y;
            this.maxY = y;
        } else {
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
    }

    public void correct360DegVersusTarget(double tg) {
        logger.entry(4, "PlotDataXY.correct360DegVersusTarget");
        int count = 0;
        for (double f : this.DataMap.keySet()) {
            double y = this.get360DegCorr(tg, this.DataMap.get(f));
            this.DataMap.put(f, y);
            if (++count == 1) {
                this.minY = y;
                this.maxY = y;
                continue;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!(y > this.maxY)) continue;
            this.maxY = y;
        }
        logger.exit(4, "PlotDataXY.correct360DegVersusTarget");
    }

    public void correct360DegVersusX() {
        logger.entry(4, "PlotDataXY.correct360DegVersusX");
        int count = 0;
        for (double f : this.DataMap.keySet()) {
            double y = this.get360DegCorr(f, this.DataMap.get(f));
            this.DataMap.put(f, y);
            if (++count == 1) {
                this.minY = y;
                this.maxY = y;
                continue;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!(y > this.maxY)) continue;
            this.maxY = y;
        }
        logger.exit(4, "PlotDataXY.correct360DegVersusX");
    }

    private double get360DegCorr(double tg, double valy) {
        double result = valy;
        if (result - tg > 270.0) {
            result -= 360.0;
        }
        if (result - tg < -270.0) {
            result += 360.0;
        }
        return result;
    }

    public void scaleX(double val) {
        logger.entry(4, "PlotDataXY.scaleX " + val);
        int count = 0;
        TreeMap<Double, Double> newMap = new TreeMap<Double, Double>();
        for (double f : this.DataMap.keySet()) {
            double newX = f * val;
            newMap.put(newX, this.DataMap.get(f));
            if (++count == 1) {
                this.minX = newX;
                this.maxX = newX;
                continue;
            }
            if (newX < this.minX) {
                this.minX = newX;
            }
            if (!(newX > this.maxX)) continue;
            this.maxX = newX;
        }
        this.DataMap = newMap;
        logger.exit(4, "PlotDataXY.scaleX");
    }

    public void scaleY(double val) {
        logger.entry(4, "PlotDataXY.scaleY " + val);
        int count = 0;
        for (double f : this.DataMap.keySet()) {
            double y = this.DataMap.get(f) * val;
            this.DataMap.put(f, y);
            if (++count == 1) {
                this.minY = y;
                this.maxY = y;
                continue;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!(y > this.maxY)) continue;
            this.maxY = y;
        }
        logger.exit(4, "PlotDataXY.scaleX");
    }

    public void logPlotData() {
        logger.entry(4, "PlotDataXY.logPlotData");
        for (double x : this.DataMap.keySet()) {
            logger.log(5, "x = " + x + ", y = " + this.DataMap.get(x));
        }
        logger.exit(4, "PlotDataXY.logPlotData");
    }
}

